% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableHC.R
\name{tables.HC}
\alias{tables.HC}
\title{Higher Criticism (HC) Test Between two Tables}
\usage{
tables.HC(tb1, tb2, alpha = 0.45, stbl = TRUE)
}
\arguments{
\item{tb1}{A one-way table with integer counts.}

\item{tb2}{A one-way table with integer counts.}

\item{alpha}{A number between 0 and 1.}

\item{stbl}{A boolean.}
}
\value{
A list containing the following fields:
 \code{HC} -- Higher Critcism (HC) score 
 \code{HC.star} -- HC score corrected to finite sample
 \code{p} -- p-value attaining \code{HC}
 \code{p.star} -- p-value attaining \code{HC.star}
}
\description{
Compute HC stasitic directly from two one-way contingency tables.
\code{stbl} -- normalize using expeted p-value 
(stbl==True) or observed (stbl==False)
\code{alpha} -- lower fraction of p-values to use
}
\examples{
text1 = "But our fish said, No ! No ! Make that cat go away ! 
           Tell that Cat in the Hat You do NOT want to play . 
           He should not be here . He should not be about . 
         He should not be here When your mother is out !"
text2 = "Now ! Now ! Have no fear . Have no fear! said the cat . 
           My tricks are not bad , Said the Cat in the Hat . Why , 
            we can have Lots of good fun, if you wish, with a game
             that I call UP - UP - UP with a fish !"

tb1 = table(strsplit(tolower(text1),' '))
tb2 = table(strsplit(tolower(text2),' '))
pv = tables.pval(tb1,tb2)
HC.vals(pv$pv)

}
