% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RemoveRowsColumns0sAndDuplicates.R
\name{RemoveRowsColumns0sAndDuplicates}
\alias{RemoveRowsColumns0sAndDuplicates}
\title{Removes rows and columns of zeros and optionnally, row or column duplicates}
\usage{
RemoveRowsColumns0sAndDuplicates(Y, rows = F, cols = F, zeros = F)
}
\arguments{
\item{Y}{A matrix}

\item{rows}{Logical Will duplicate rows be removed?}

\item{cols}{Logical Will duplicate columns be removed?}

\item{zeros}{Logical Will rows and columns of zeros be removed?}
}
\value{
A matrix with rows and columns removed as requested
}
\description{
Removes rows and columns of zeros and optionnally, row or column duplicates
}
\examples{
RemoveRowsColumns0sAndDuplicates(matrix(1:3,nrow=3,ncol=2),cols=TRUE)

RemoveRowsColumns0sAndDuplicates(cbind(matrix(1:3,nrow=3,ncol=2),rep(0,3)),cols=TRUE)

RemoveRowsColumns0sAndDuplicates(cbind(matrix(1:3,nrow=3,ncol=2),rep(0,3)),zeros=TRUE)

RemoveRowsColumns0sAndDuplicates(matrix(0,nrow=3,ncol=3),zeros=TRUE)

}
