% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TempleMetrics.R
\name{lldistreg}
\alias{lldistreg}
\title{lldistreg}
\usage{
lldistreg(formla, xformla = NULL, data, yvals, tvals, link = "logit",
  cl = 1)
}
\arguments{
\item{formla}{y ~ t , t must be a single continuous variable}

\item{xformla}{~x, x are other (non-smoothed) variables
included in the model}

\item{data}{the dataset}

\item{yvals}{all the values of y to compute F(y|t,x)}

\item{tvals}{the values of the continuous treatment to comput F(y|t,x)}

\item{link}{which link function to use, it can be anything accepted
by glm (for example, logit, probit, or cloglog), the default is "logit"}

\item{cl}{the number of clusters to use, default is 1}
}
\value{
a list of llDR objects that are indexed by the values in yvals
 and tvals
}
\description{
the main function for running "local" distribution regressions.
 This function runs a local regression that is local for a single
 (scalar) continuous treatment variable.  It also allows for other variables
 but it does not smooth over these variables.
}
\examples{
data(igm)
lldistreg(lcfincome ~ lfincome, ~HEDUC, igm, 10, 10)

}
