% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exponential.R
\name{fit.Exp}
\alias{fit.Exp}
\title{Exponential Distribution Parameter Estimation}
\usage{
fit.Exp(time, status, sig = 0.05)
}
\arguments{
\item{time}{Observation times.}

\item{status}{Status indicator, coded as 1 if an event was observed, 0 if censored.}

\item{sig}{Significance level, for CIs.}
}
\value{
An object of class \code{fit} containing the following:
\describe{
 \item{Parameters}{The estimated model parameters.}
 \item{Information}{The observed information matrix.}
 \item{Outcome}{The fitted mean, median, and variance of the time to event distribution.}
}
}
\description{
Estimates parameters for exponential event times subject to non-informative
right censoring. The exponential distribution is parameterized in terms
of the rate \eqn{\lambda}: \deqn{f(t) = \lambda e^{-\lambda t}, t>0}
}
\examples{
# Simulate
D = rWeibull(n=1e3,a=1,l=2);
# Estimate
M = fitParaSurv(time=D$time,status=D$status,dist="exp");
}
\seealso{
\itemize{
  \item{Fitting function for parametric survival distributions \code{\link{fitParaSurv}}}
}
}
