% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{fit.Gamma}
\alias{fit.Gamma}
\title{Gamma Distribution Parameter Estimation}
\usage{
fit.Gamma(time, status, sig = 0.05, init = NULL, eps = 1e-06,
  maxit = 10, report = F)
}
\arguments{
\item{time}{Observation times.}

\item{status}{Status indicator, coded as 1 if an event was observed, 0 if
censored.}

\item{sig}{Significance level, for CIs.}

\item{init}{List of initial parameter values, including the log of the shape
parameter "la" and the log of the rate parameter "ll".}

\item{eps}{Tolerance for Newton-Raphson iterations.}

\item{maxit}{Maximum number of NR iterations.}

\item{report}{Report fitting progress?}
}
\value{
An object of class \code{fit} containing the following:
\describe{
 \item{Parameters}{The estimated shape \eqn{\alpha} and rate \eqn{\lambda}.}
 \item{Information}{The observed information matrix.}
 \item{Outcome}{The fitted mean, median, and variance.}
}
}
\description{
Estimates parameters for gamma event times subject to non-informative
right censoring. The gamma distribution is parameterized in terms
of the shape \eqn{\alpha} and rate \eqn{\lambda}:
\deqn{f(t) = \frac{\lambda}{\Gamma(\alpha)}(\lambda t)^{\alpha-1}e^{-\lambda t}, t>0}
}
\examples{
# Simulate
D = rGamma(n=1e3,a=2,l=2);
# Estimate
M = fitParaSurv(time=D$time,status=D$status,dist="gamma");
}
\seealso{
\itemize{
  \item{Fitting function for parametric survival distributions \code{\link{fitParaSurv}}}
}
}
