% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Contours.R
\name{ColourTernary}
\alias{ColourTernary}
\alias{ColorTernary}
\title{Colour a ternary plot according to the output of a function}
\usage{
ColourTernary(values, spectrum = viridisLite::viridis(256L, alpha = 0.6),
  resolution = sqrt(ncol(values)),
  direction = getOption("ternDirection"))

ColorTernary(values, spectrum = viridisLite::viridis(256L, alpha = 0.6),
  resolution = sqrt(ncol(values)),
  direction = getOption("ternDirection"))
}
\arguments{
\item{values}{Numeric matrix specifying the values associated with each
point, generated using \code{\link{TernaryPointValues}}.}

\item{spectrum}{Vector of colours to use as a spectrum, or \code{NULL} to use
\code{values['z', ]}.}

\item{resolution}{The number of triangles whose base should lie on the longest
axis of the triangle.  Higher numbers will result in smaller subdivisions and smoother
colour gradients, but at a computational cost.}

\item{direction}{(optional) Integer specifying the direction that the current ternary plot
should point: 1, up; 2, right; 3, down; 4, left.}
}
\description{
Colour a ternary plot according to the output of a function
}
\examples{
TernaryPlot(alab = 'a', blab = 'b', clab = 'c')
 
FunctionToContour <- function (a, b, c) {
  a - c + (4 * a * b) + (27 * a * b * c)
}

values <- TernaryPointValues(FunctionToContour, resolution = 24L)
ColourTernary(values)
TernaryContour(FunctionToContour, resolution = 36L)


TernaryPlot()
values <- TernaryPointValues(rgb, resolution = 20)
ColourTernary(values, spectrum = NULL)

}
\seealso{
Other contour plotting functions: \code{\link{TernaryContour}},
  \code{\link{TernaryDensityContour}},
  \code{\link{TernaryPointValues}}

Other functions for colouring and shading: \code{\link{TernaryTiles}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{contour plotting functions}
\concept{functions for colouring and shading}
