% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/static_functions.R
\docType{methods}
\name{Static}
\alias{Static}
\alias{Static,config_Static-method}
\title{Run Static Test Assembly}
\usage{
Static(config, constraints)

\S4method{Static}{config_Static}(config, constraints)
}
\arguments{
\item{config}{A \code{\linkS4class{config_Static}} object containing configuration options. Use \code{\link{createStaticTestConfig}} for this.}

\item{constraints}{A list representing optimization constraints. Use \code{\link{loadConstraints}} for this.}
}
\value{
A list containing the following entries:
\itemize{
  \item{\code{MIP}} A list containing the result from MIP solver.
  \itemize{
    \item{\code{solution}} Solution vector. Each value represents an item. A value of 1 indicates the item was selected.
    \item{\code{objval}} Objective value of the solution.
    \item{\code{status}} Status value indicating whether an optimal solution was found.
  }
  \item{\code{selected}} The attributes of the selected items.
  \item{\code{solver}} The name of the MIP solver used in the assembly.
  \item{\code{obj_value}} Objective value of the solution. Identical to the one above.
  \item{\code{solve_time}} The elapsed time in running the solver.
}
}
\description{
Perform static (fixed-form) test assembly with specified configurations.
}
\examples{
config_science <- createStaticTestConfig(
  list(
    method = "MAXINFO",
    target_location = c(-1, 1)
  )
)
solution <- Static(config_science, constraints_science)

}
\references{
\insertRef{van_der_linden_linear_2005}{TestDesign}
}
