% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensions.R, R/plot_functions.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,item_pool-method}
\alias{plot,output_Static-method}
\alias{plot,constraints-method}
\alias{plot,output_Shadow-method}
\alias{plot,output_Shadow_all-method}
\title{Extension of plot() for objects in TestDesign package}
\usage{
\S4method{plot}{item_pool}(
  x,
  y,
  type = "info",
  theta = seq(-3, 3, 0.1),
  info_type = "FISHER",
  plot_sum = TRUE,
  select = NULL,
  examinee_id = 1,
  position = NULL,
  theta_range = c(-5, 5),
  color = "blue",
  z_ci = 1.96,
  simple = TRUE,
  theta_segment = "Estimated",
  color_final = "blue",
  ...
)

\S4method{plot}{output_Static}(
  x,
  y,
  type = NULL,
  theta = seq(-3, 3, 0.1),
  info_type = "FISHER",
  plot_sum = TRUE,
  select = NULL,
  examinee_id = 1,
  position = NULL,
  theta_range = c(-5, 5),
  color = "blue",
  z_ci = 1.96,
  simple = TRUE,
  theta_segment = "Estimated",
  color_final = "blue",
  ...
)

\S4method{plot}{constraints}(
  x,
  y,
  type = "info",
  theta = seq(-3, 3, 0.1),
  info_type = "FISHER",
  plot_sum = TRUE,
  select = NULL,
  examinee_id = 1,
  position = NULL,
  theta_range = c(-5, 5),
  color = "blue",
  z_ci = 1.96,
  simple = TRUE,
  theta_segment = "Estimated",
  color_final = "blue",
  ...
)

\S4method{plot}{output_Shadow}(
  x,
  y,
  type = "audit",
  theta = seq(-3, 3, 0.1),
  info_type = "FISHER",
  plot_sum = TRUE,
  select = NULL,
  examinee_id = 1,
  theta_range = c(-5, 5),
  color = "blue",
  z_ci = 1.96,
  simple = FALSE,
  theta_segment = "Estimated",
  color_final = "blue",
  ...
)

\S4method{plot}{output_Shadow_all}(
  x,
  y,
  type = "audit",
  theta = seq(-3, 3, 0.1),
  info_type = "FISHER",
  plot_sum = TRUE,
  select = NULL,
  examinee_id = 1,
  position = NULL,
  theta_range = c(-5, 5),
  color = "blue",
  z_ci = 1.96,
  simple = FALSE,
  theta_segment = "Estimated",
  color_final = "blue",
  ...
)
}
\arguments{
\item{x}{accepts the following signatures:
\itemize{
  \item{\code{\linkS4class{item_pool}}}: plot information and expected scores.
  \item{\code{\linkS4class{constraints}}}: plot information range based on the test length constraint.
  \item{\code{\linkS4class{output_Static}}}: plot information and expected scores based on the fixed assembly solution.
  \item{\code{\linkS4class{output_Shadow_all}}}: plot audit trail, shadow test chart, and exposure rates from the adaptive assembly solution.
  \item{\code{\linkS4class{output_Shadow}}}: plot audit trail and shadow test chart from the adaptive assembly solution.
}}

\item{y}{not used, exists for compatibility with \code{\link[base]{plot}} in the base R package.}

\item{type}{the type of plot.
\itemize{
   \item{\code{info} plots information from \code{\linkS4class{item_pool}}, \code{\linkS4class{output_Static}}, and \code{\linkS4class{output_Shadow_all}}.}
   \item{\code{score} plots expected scores from \code{\linkS4class{item_pool}} and \code{\linkS4class{output_Static}}.}
   \item{\code{audit} plots audit trail from \code{\linkS4class{output_Shadow_all}} and \code{\linkS4class{output_Shadow}}.}
   \item{\code{shadow} plots shadow test chart from \code{\linkS4class{output_Shadow_all}} and \code{\linkS4class{output_Shadow}}.}
   \item{\code{exposure} plots exposure rates from \code{\linkS4class{output_Shadow_all}}.}
}}

\item{theta}{the theta grid to use in plotting. (default = \code{seq(-3, 3, .1)})}

\item{info_type}{the type of information. Currently accepts \code{FISHER}. (default = \code{FISHER})}

\item{plot_sum}{used in \code{\linkS4class{item_pool}} objects.
\itemize{
   \item{if \code{TRUE} then plot pool-level values.}
   \item{if \code{FALSE} then plot item-level values, and repeat for all items in the pool.}
   \item{(default = \code{TRUE})}
}}

\item{select}{used in \code{\linkS4class{item_pool}} objects. Item indices to subset.}

\item{examinee_id}{used in \code{\linkS4class{output_Shadow}} and \code{\linkS4class{output_Shadow_all}} with \code{type = 'audit'} and \code{type = 'shadow'}. The examinee numeric ID to draw the plot.}

\item{position}{used in \code{\linkS4class{output_Shadow_all}} with \code{type = 'info'}. The item position to draw the plot.}

\item{theta_range}{used in \code{\linkS4class{output_Shadow}} and \code{\linkS4class{output_Shadow_all}} with \code{type = 'audit'}. The theta range to plot. (default = \code{c(-5, 5)})}

\item{color}{the color of the curve.}

\item{z_ci}{used in \code{\linkS4class{output_Shadow}} and \code{\linkS4class{output_Shadow_all}} with \code{type = 'audit'}. The range to use for confidence intervals. (default = \code{1.96})}

\item{simple}{used in \code{\linkS4class{output_Shadow}} and \code{\linkS4class{output_Shadow_all}} with \code{type = 'shadow'}. If \code{TRUE}, simplify the chart by hiding unused items.}

\item{theta_segment}{used in \code{\linkS4class{output_Shadow_all}} with \code{type = 'exposure'}. The type of theta to determine exposure segments. Accepts \code{Estimated} or \code{True}. (default = \code{Estimated})}

\item{color_final}{used in \code{\linkS4class{output_Shadow_all}} with \code{type = 'exposure'}. The color of item-wise exposure rates, only counting the items administered in the final theta segment as exposed.}

\item{...}{arguments to pass onto \code{\link{plot}}.}
}
\description{
Extension of plot() for objects in TestDesign package
}
\examples{

subitempool <- itempool_science[1:8]

## Plot item information of a pool
plot(subitempool)
plot(itempool_science, select = 1:8)

## Plot expected score of a pool
plot(subitempool, type = "score")
plot(itempool_science, type = "score", select = 1:8)

## Plot assembly results from Static()
cfg <- createStaticTestConfig()
solution <- Static(cfg, constraints_science)
plot(solution)                 # defaults to the objective type
plot(solution, type = "score") # plot expected scores

## Plot attainable information range from constraints
plot(constraints_science)

## Plot assembly results from Shadow()
cfg <- createShadowTestConfig()
set.seed(1)
solution <- Shadow(cfg, constraints_science, true_theta = rnorm(1))
plot(solution, type = 'audit' , examinee_id = 1)
plot(solution, type = 'shadow', examinee_id = 1, simple = TRUE)

## plot(solution, type = 'exposure')

}
