% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_operators.R
\docType{methods}
\name{makeTest}
\alias{makeTest}
\alias{makeTest,item_pool-method}
\title{Generate a test object}
\usage{
makeTest(
  object,
  theta = seq(-4, 4, 0.1),
  info_type = "FISHER",
  true_theta = NULL
)

\S4method{makeTest}{item_pool}(
  object,
  theta = seq(-4, 4, 0.1),
  info_type = "FISHER",
  true_theta = NULL
)
}
\arguments{
\item{object}{an \code{\linkS4class{item_pool}} object.}

\item{theta}{a grid of theta values.}

\item{info_type}{the type of information.}

\item{true_theta}{(optional) true theta values to simulate response data.}
}
\description{
\code{\link{makeTest}} is a function for creating a \code{\linkS4class{test}} object.
This is used in \code{\link{Shadow}} to determine all necessary data prior to the main simulation, so that they are not affected by random number generation.
}
\examples{
test <- makeTest(itempool_science, seq(-3, 3, 1))
}
