% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading_functions.R
\docType{class}
\name{st_attrib-class}
\alias{st_attrib-class}
\alias{loadStAttrib}
\title{Load set/stimulus/passage attributes}
\usage{
loadStAttrib(object, item_attrib, file = NULL)
}
\arguments{
\item{object}{set attributes. Can be a \code{\link{data.frame}} or the file path of a .csv file. The content should at least include the column 'STID' referring to the column 'STID' in the \code{data} slot of the \code{\linkS4class{item_attrib}} object.}

\item{item_attrib}{an \code{\linkS4class{item_attrib}} object. Use \code{\link{loadItemAttrib}} for this.}

\item{file}{(deprecated) use \code{object} argument instead.}
}
\value{
\code{\link{loadStAttrib}} returns a \code{\linkS4class{st_attrib}} object.

\itemize{
  \item{\code{data}} a \code{\link{data.frame}} containing stimulus attributes.
}
}
\description{
\code{\link{loadStAttrib}} is a data loading function to create an \code{\linkS4class{st_attrib}} object.
\code{\link{loadStAttrib}} can read stimulus attributes a \code{\link{data.frame}} or a .csv file.
}
\examples{
## Read from data.frame:
itempool_reading   <- loadItemPool(itempool_reading_data)
itemattrib_reading <- loadItemAttrib(itemattrib_reading_data, itempool_reading)
stimattrib_reading <- loadStAttrib(stimattrib_reading_data, itemattrib_reading)

## Read from file: write to tempdir() for illustration and clean afterwards
f <- file.path(tempdir(), "stimattrib_reading.csv")
write.csv(stimattrib_reading_data, f, row.names = FALSE)
stimattrib_reading <- loadStAttrib(f, itemattrib_reading)
file.remove(f)

## TestDesign 1.1.0 - Deprecated arguments
\dontrun{
loadStAttrib(object = "satt.csv", item_attrib) # is equivalent to
loadStAttrib(file   = "satt.csv", item_attrib) # pre 1.1.0
}

}
\seealso{
\code{\link{dataset_reading}} for examples.
}
