% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_functions.R
\name{logitHyperPars}
\alias{logitHyperPars}
\title{Convert mean and standard deviation into logit-normal distribution parameters}
\usage{
logitHyperPars(mean, sd)
}
\arguments{
\item{mean}{the desired mean.}

\item{sd}{the desired standard deviation.}
}
\value{
\code{\link{logitHyperPars}} returns two values. These can be directly supplied to \code{\link[logitnorm]{rlogitnorm}}.
}
\description{
\code{\link{logitHyperPars}} is a function for calculating parameters for a logit-normal distribution, such that the distribution yields desired mean and standard deviation.
Used for sampling the c-parameter.
}
\examples{
pars <- logitHyperPars(0.2, 0.1)
x <- logitnorm::rlogitnorm(1000000, pars[1], pars[2])
mean(x) # close to 0.2
sd(x)   # close to 0.1

}
