% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/van_vark.R
\name{van_vark}
\alias{van_vark}
\title{Graphical and statistical representation of dimorphism differences.}
\usage{
van_vark(
  x,
  W = NULL,
  q = 2,
  Trait = 1,
  Pop = 2,
  plot = TRUE,
  lower.tail = FALSE,
  digits = 4
)
}
\arguments{
\item{x}{A Data frame of means and sample sizes for different populations or
a list of the summary data frame with Pooled within-group variance-covariance
matrix.}

\item{W}{Pooled within-group variance-covariance matrix supplied if x is a
dataframe , Default:NULL}

\item{q}{Number of canonical variates to retain for chi square test, Default:
2}

\item{Trait}{number of column containing names of traits Default: 1.}

\item{Pop}{Number of the column containing populations' names, Default: 2}

\item{plot}{Logical; if TRUE returns a graphical representation of dimorphism
differences, Default: TRUE}

\item{lower.tail}{Logical; if TRUE probabilities are `P[X <= x]`,
otherwise, `P[X > x]`., Default: FALSE}

\item{digits}{Number of significant digits, Default: 4}
}
\value{
The output includes a two-dimensional plot that illustrate the
  existing differences between tested populations and a statistical test of
  significance for the difference in dimorphism using chi square
  distribution.
}
\description{
Provides testing for differences in patterning of sexual
  dimorphism between populations, as well as for evolutionary trends that may
  characterize other species. The test is based on the computation of the
  first q canonical variates (q=2 by default) or multiple discriminant
  functions to develop various tests of sexual dimorphism in any two
  populations A and B.
}
\details{
Input is a data frame of means and sample sizes similar to
  \link{Howells_summary} with the same naming conventions used throughout the
  functions but with the standard deviation columns removed.
}
\note{
For plot labels to be fully visualized, maximizing image size is advised.
}
\examples{
# selecting means and sample sizes
van_vark_data <- Howells_summary[!endsWith(
  x = names(Howells_summary),
  suffix = "dev"
)]
# running the function
van_vark(van_vark_data, Howells_V)
}
\references{
Van Vark, G. N., et al. "Some multivariate tests for differences
in sexual dimorphism between human populations." Annals of human biology
16.4 (1989): 301-310.
}
