% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aov_ss.R
\name{aov_ss}
\alias{aov_ss}
\title{Sex Specific One way ANOVA From Summary statistics}
\usage{
aov_ss(
  x,
  Pop = 1,
  pairwise = TRUE,
  letters = FALSE,
  es_anova = "none",
  digits = 4,
  CI = 0.95
)
}
\arguments{
\item{x}{A data frame containing summary statistics.}

\item{Pop}{Number of the column containing populations' names, Default: 1}

\item{pairwise}{Logical; if TRUE runs multiple pairwise comparisons on
different populations using Tukey-Kramer's post hoc test, Default: TRUE}

\item{letters}{Logical; if TRUE returns letters for pairwise comparisons
where significantly different populations are given different letters,
Default: FALSE'}

\item{es_anova}{Type of effect size either "f2" for f squared,"eta2" for eta
squared, "omega2" for omega squared or "none", Default:"none".}

\item{digits}{Number of significant digits, Default: 4}

\item{CI}{confidence interval coverage takes value from 0 to 1, Default: 0.95.}
}
\value{
Sex specific ANOVA tables and pairwise comparisons in tidy format.
}
\description{
Calculates sex specific one way ANOVA from summary statistics.
}
\details{
Data is entered as a data frame of summary statistics where
the column containing population names is chosen by position (first by
default), other columns of summary data should have specific names (case
sensitive) similar to \link{baboon.parms_df}
}
\examples{
# Comparisons of femur head diameter in four populations
df <- data.frame(
  Pop = c("Turkish", "Bulgarian", "Greek", "Portuguese"),
  m = c(150.00, 82.00, 36.00, 34.00),
  f = c(150.00, 58.00, 34.00, 24.00),
  M.mu = c(49.39, 48.33, 46.99, 45.20),
  F.mu = c(42.91, 42.89, 42.44, 40.90),
  M.sdev = c(3.01, 2.53, 2.47, 2.00),
  F.sdev = c(2.90, 2.84, 2.26, 2.90)
)
aov_ss(x = df)
}
\references{
#For the femur head diameter data

  F. Curate, C. Umbelino, A. Perinha, C. Nogueira, A.M. Silva, E.
  Cunha, Sex determination from the femur in Portuguese populations with
  classical and machinelearning classifiers, J. Forensic Leg. Med. (2017) ,
  doi:http://dx.doi.org/10.1016/j. jflm.2017.08.011.

  O. Gulhan, Skeletal Sexing Standards of Human Remains in Turkey (PhD thesis), Cranfield
  University, 2017 [Dataset].

  P. Timonov, A. Fasova, D. Radoinova, A.Alexandrov, D. Delev, A study of sexual dimorphism
  in the femur among contemporary Bulgarian population, Euras. J. Anthropol. 5 (2014) 46–53.

  E.F. Kranioti, N. Vorniotakis, C. Galiatsou, M.Y. Iscan , M.
  Michalodimitrakis, Sex identification and software development using
  digital femoral head radiographs, Forensic Sci. Int. 189 (2009) 113.e1–7.
}
