% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_func_apply.R
\name{standard_test_func}
\alias{standard_test_func}
\title{Create a standard test function.}
\usage{
standard_test_func(func, scale_it_ = F, scale_low_ = NULL,
  scale_high_ = NULL, noise_ = 0, ...)
}
\arguments{
\item{func}{A function that takes a vector representing a single point.}

\item{scale_it_}{Should the function scale the inputs from [0, 1]^D to
[scale_low_, scale_high_] by default? This can be overridden when
actually giving the output function points to evaluate.}

\item{scale_low_}{What is the default lower bound of the data?}

\item{scale_high_}{What is the default upper bound of the data?}

\item{noise_}{Should noise be added to the function by default?}

\item{...}{Parameters passed to func when evaluating points.}
}
\value{
A test function created using the standard_test_func template.
}
\description{
This makes it easier to create
many functions that follow the same template.
R CMD check doesn't like the ... if this command is used to
create functions in the package, so it is not currently used.
}
\examples{
.gaussian1 <- function(x, center=.5, s2=.01) {
  exp(-sum((x-center)^2/2/s2))
}
gaussian1 <- standard_test_func(.gaussian1, scale_it=FALSE, scale_low = c(0,0), scale_high = c(1,1))
curve(gaussian1(matrix(x,ncol=1)))
}

