% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions1.R, R/test_func_apply.R
\name{branin}
\alias{branin}
\alias{borehole}
\alias{franke}
\alias{zhou1998}
\alias{currin1991}
\alias{lim2002}
\alias{banana}
\alias{gaussian1}
\alias{sinumoid}
\alias{waterfall}
\alias{sqrtsin}
\alias{powsin}
\alias{OTL_Circuit}
\alias{GoldsteinPrice}
\alias{GoldsteinPriceLog}
\alias{ackley}
\alias{piston}
\alias{wingweight}
\alias{welch}
\alias{robotarm}
\alias{RoosArnold}
\alias{Gfunction}
\alias{beale}
\alias{easom}
\alias{griewank}
\alias{hump}
\alias{levy}
\alias{michalewicz}
\alias{rastrigin}
\alias{moon_high}
\alias{linkletter_nosignal}
\alias{morris}
\alias{detpep8d}
\alias{hartmann}
\alias{quad_peaks}
\alias{quad_peaks_slant}
\alias{test_func_apply}
\title{Test function.}
\usage{
branin(x, scale_it = T, scale_low = c(-5, 0), scale_high = c(10, 15),
  noise = 0)

borehole(x, scale_it = T, scale_low = c(0.05, 100, 63070, 990, 63.1, 700,
  1120, 9855), scale_high = c(0.15, 50000, 115600, 1110, 116, 820, 1680,
  12045), noise = 0)

franke(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1),
  noise = 0)

zhou1998(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1),
  noise = 0)

currin1991(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1),
  noise = 0)

lim2002(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1),
  noise = 0)

banana(x, scale_it = T, scale_low = c(-20, -10), scale_high = c(20, 5),
  noise = 0)

gaussian1(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1),
  noise = 0)

sinumoid(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1),
  noise = 0)

waterfall(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1),
  noise = 0)

sqrtsin(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1),
  noise = 0, freq = 2 * pi)

powsin(x, scale_it = F, scale_low = c(0, 0), scale_high = c(1, 1),
  noise = 0, freq = 2 * pi, pow = 0.7)

OTL_Circuit(x, scale_it = T, scale_low = c(50, 25, 0.5, 1.2, 0.25, 50),
  scale_high = c(150, 70, 3, 2.5, 1.2, 300), noise = 0)

GoldsteinPrice(x, scale_it = T, scale_low = c(-2, -2), scale_high = c(2,
  2), noise = 0)

GoldsteinPriceLog(x, scale_it = T, scale_low = c(-2, -2),
  scale_high = c(2, 2), noise = 0)

ackley(x, scale_it = T, scale_low = -32.768, scale_high = 32.768,
  noise = 0, a = 20, b = 0.2, c = 2 * pi)

piston(x, scale_it = T, scale_low = c(30, 0.005, 0.002, 1000, 90000, 290,
  340), scale_high = c(60, 0.02, 0.01, 5000, 110000, 296, 360), noise = 0)

wingweight(x, scale_it = T, scale_low = c(150, 220, 6, -10, 16, 0.5, 0.08,
  2.5, 1700, 0.025), scale_high = c(200, 300, 10, 10, 45, 1, 0.18, 6, 2500,
  0.08), noise = 0)

welch(x, scale_it = T, scale_low = c(-0.5), scale_high = c(0.5),
  noise = 0)

robotarm(x, scale_it = T, scale_low = rep(0, 8), scale_high = c(rep(2 *
  pi, 4), rep(1, 4)), noise = 0)

RoosArnold(x, scale_it = F, scale_low = 0, scale_high = 1, noise = 0)

Gfunction(x, scale_it = F, scale_low = 0, scale_high = 1, noise = 0,
  ...)

beale(x, scale_it = T, scale_low = -4.5, scale_high = 4.5, noise = 0,
  ...)

easom(x, scale_it = T, scale_low = -4.5, scale_high = 4.5, noise = 0,
  ...)

griewank(x, scale_it = T, scale_low = -600, scale_high = 600, noise = 0,
  ...)

hump(x, scale_it = T, scale_low = -5, scale_high = 5, noise = 0, ...)

levy(x, scale_it = T, scale_low = -10, scale_high = 10, noise = 0, ...)

michalewicz(x, scale_it = T, scale_low = 0, scale_high = pi, noise = 0,
  ...)

rastrigin(x, scale_it = T, scale_low = -5.12, scale_high = 5.12,
  noise = 0, ...)

moon_high(x, scale_it = F, scale_low = 0, scale_high = 1, noise = 0,
  ...)

linkletter_nosignal(x, scale_it = F, scale_low = 0, scale_high = 1,
  noise = 0, ...)

morris(x, scale_it = T, scale_low = 0, scale_high = 1, noise = 0, ...)

detpep8d(x, scale_it = T, scale_low = 0, scale_high = 1, noise = 0, ...)

hartmann(x, scale_it = F, scale_low = 0, scale_high = 1, noise = 0, ...)

quad_peaks(x, scale_it = T, scale_low = 0, scale_high = 1, noise = 0,
  ...)

quad_peaks_slant(x, scale_it = T, scale_low = 0, scale_high = 1,
  noise = 0, ...)

test_func_apply(func, x, scale_it, scale_low, scale_high, noise = 0, ...)
}
\arguments{
\item{x}{Input value, either a matrix whose rows are points or
a vector for a single point. Be careful with 1-D functions.}

\item{scale_it}{Should the data be scaled from [0, 1]^D to
[scale_low, scale_high]? This means the input data is confined
to be in [0, 1]^D, but the function isn't.}

\item{scale_low}{Lower bound for each variable}

\item{scale_high}{Upper bound for each variable}

\item{noise}{If white noise should be added, specify the
standard deviation for normal noise}

\item{freq}{Wave frequency for sqrtsin and powsin}

\item{pow}{Power for powsin}

\item{a}{A constant for ackley()}

\item{b}{A constant for ackley()}

\item{c}{A constant for ackley()}

\item{...}{Additional parameters for func}

\item{func}{A function to evaluate}
}
\value{
Function values at x
}
\description{
branin: A function.
2 dimensional function.

borehole: A function estimating water flow through a borehole.
8 dimensional function.

franke: A function.
2 dimensional function.

zhou1998: A function.
2 dimensional function.

currin1991: A function.
2 dimensional function.

lim2002: Some function?
2 dimensional function.

banana: A banana shaped function.
2 dimensional function.

gaussian1: A Gaussian function centered at 0.5.
Any dimensional function.

sinumoid: A sinusoid added to a sigmoid function.
2 dimensional function.

waterfall: A sinusoid added to a sigmoid function.
2 dimensional function.

sqrtsin: A square root of a sine function.
Any dimensional function.

powsin: A sine function raised to a power keeping its original sign.
Any dimensional function.

OTL_Circuit: OTL Circuit.
6 dimensional function.

GoldsteinPrice: Goldstein-Price function. Exponential scale, you
might want to use GoldsteinPriceLog instead
2 dimensional function.

GoldsteinPriceLog: Goldstein-Price function on a log scale.
2 dimensional function.

ackley: Ackley function.
2 dimensional function.

piston: Piston simulation function.
7 dimensional function.

wingweight: Wing weight function.
10 dimensional function.

welch: Welch et al (1992) function.
20 dimensional function.

robotarm: Robot arm function.
8 dimensional function.

RoosArnold: Roos & Arnold (1963) function.
d dimensional function.

Gfunction: G-function
d dimensional function.

beale: Beale function
2 dimensional function.

easom: Easom function
2 dimensional function.

griewank: Griewank function
n dimensional function.

hump: Hump function
2 dimensional function.

levy: Levy function
n dimensional function.

michalewicz: Michalewicz function
n dimensional function.

rastrigin: Rastrigin function
n dimensional function.

moon_high: Moon (2010) high-dimensional function for screening
20 dimensional function.

linkletter_nosignal: Linkletter (2006) no signal function, just returns zero
d dimensional function.

Morris: Morris function
20 dimensional function.

detpep8d: detpep8d function
8 dimensional function.

hartmann: hartmann function
6 dimensional function.

quad_peaks: quad_peaks function
2 dimensional function.

quad_peaks_slant: quad_peaks_slant function
2 dimensional function.

General function for evaluating a test function
}
\examples{
branin(runif(2))
branin(matrix(runif(20), ncol=2))
borehole(runif(8))
borehole(matrix(runif(80), ncol=8))
franke(runif(2))
zhou1998(runif(2))
currin1991(runif(2))
lim2002(runif(2))
banana(runif(2))
x <- y <- seq(0, 1, len=100)
z <- outer(x, y, Vectorize(function(a, b){banana(c(a, b))}))
contour(x, y, z)
gaussian1(runif(2))
sinumoid(runif(2))
x <- y <- seq(0, 1, len=100)
z <- outer(x, y, Vectorize(function(a, b){sinumoid(c(a, b))}))
contour(x, y, z)
waterfall(runif(2))
sqrtsin(runif(1))
curve(sqrtsin(matrix(x,ncol=1)))
powsin(runif(1))#,pow=2)
OTL_Circuit(runif(6))
OTL_Circuit(matrix(runif(60),ncol=6))
GoldsteinPrice(runif(2))
GoldsteinPrice(matrix(runif(60),ncol=2))
GoldsteinPriceLog(runif(2))
GoldsteinPriceLog(matrix(runif(60),ncol=2))
ackley(runif(2))
ackley(matrix(runif(60),ncol=2))
piston(runif(7))
piston(matrix(runif(7*20),ncol=7))
wingweight(runif(10))
wingweight(matrix(runif(10*20),ncol=10))
welch(runif(20))
welch(matrix(runif(20*20),ncol=20))
robotarm(runif(8))
robotarm(matrix(runif(8*20),ncol=8))
RoosArnold(runif(8))
RoosArnold(matrix(runif(8*20),ncol=8))
Gfunction(runif(8))
Gfunction(matrix(runif(8*20),ncol=8))
beale(runif(2))
beale(matrix(runif(2*20),ncol=2))
easom(runif(2))
easom(matrix(runif(2*20),ncol=2))
griewank(runif(2))
griewank(matrix(runif(2*20),ncol=2))
hump(runif(2))
hump(matrix(runif(2*20),ncol=2))
levy(runif(2))
levy(matrix(runif(2*20),ncol=2))
michalewicz(runif(2))
michalewicz(matrix(runif(2*20),ncol=2))
rastrigin(runif(2))
rastrigin(matrix(runif(2*20),ncol=2))
moon_high(runif(20))
moon_high(matrix(runif(20*20),ncol=20))
linkletter_nosignal(runif(2))
linkletter_nosignal(matrix(runif(2*20),ncol=2))
morris(runif(20))
morris(matrix(runif(20*20),ncol=20))
detpep8d(runif(2))
detpep8d(matrix(runif(2*20),ncol=2))
hartmann(runif(2))
hartmann(matrix(runif(6*20),ncol=6))
quad_peaks(runif(2))
quad_peaks(matrix(runif(2*20),ncol=2))
quad_peaks_slant(runif(2))
quad_peaks_slant(matrix(runif(2*20),ncol=2))
x <- matrix(seq(0,1,length.out=10), ncol=1)
y <- test_func_apply(sin, x, TRUE, 0, 2*pi, .05)
plot(x,y)
curve(sin(2*pi*x), col=2, add=TRUE)
}
\references{
http://www.abe.ufl.edu/jjones/ABE_5646/2010/Morris.1991%20SA%20paper.pdf

http://www.tandfonline.com/doi/pdf/10.1198/TECH.2010.09157?needAccess=true
}
