% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapBiPolar.R
\name{mapBiPolar}
\alias{mapBiPolar}
\title{Function: Map a bipolar theme broken around a neutral value}
\usage{
mapBiPolar(var.name,shape, break.value=0, neg.breaks=4, pos.breaks=neg.breaks,
                  map.title="", legend.title=deparse(substitute(var.name)),
                  legend.pos="bottomleft", legend.cex=1, add.to.map=FALSE)
}
\arguments{
\item{var.name}{A variable to be mapped in a bipolar theme. If it is in a data-frame,
then the data-frame must be refered to, e.g., \code{df$var}}

\item{shape}{An existing spatial polygon or spatial polygon data-frame}

\item{break.value}{Neutral value separating the negative branch from the
positive branch of the variable}

\item{neg.breaks}{Number of classes in the negative branch (default=4)}

\item{pos.breaks}{Number of classes in the positive branch (default=\code{neg.breaks})}

\item{map.title}{Character string with map title}

\item{legend.title}{Character string with legend title (default=\code{var.name})}

\item{legend.pos}{Location of legend in the map frame (default=\code{"bottomleft"})}

\item{legend.cex}{Relative font size of the legend}

\item{add.to.map}{Logical to start a new map frame if \code{FALSE} or overlay onto an
existing map frame if \code{TRUE}}
}
\value{
\code{NULL}
}
\description{
\code{mapBiPolar} generates a map of a bipolar theme variable
}
\details{
The function \code{mapBiPolar} maps a \emph{bipolar variable} with a
  \emph{divergent color ramp} around a specific break values. A legend is generated.
  Below values are coded blue and above values red. Each branch is broken
  into 'quantiles'. Therefore, the number of class in each branch should be
  proportional to the number of observations in each class. NA's are permitted.
}
\examples{
library(maptools)
validTractShp <- tractShp[!is.na(tractShp$BUYPOW), ]         # Remove 2 tracts with NA's
mapColorQual(validTractShp$CITYPERI, validTractShp,
             map.title="Cities and Peripherie in Dallas County",
             legend.title="Regions")

mapColorRamp(validTractShp$bad1500D, validTractShp, breaks=9,
             map.title="Density of Convenience Stores in Dallas County\nbw=1500 meters",
             legend.title="Junk Food")

hist(tractShp$LRRmedD)
mapBiPolar(validTractShp$LRRmedD, validTractShp, break.value=0,
           neg.breaks=5, pos.breaks=5,
           map.title="LRR: log(f(junk food),f(healthy food))\nbw=medium",
           legend.title="log relative risk")

}
\author{
Michael Tiefelsdorf <tiefelsdorf@utdallas.edu>
}
