% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tv_dictionary.R
\name{tv_dictionary}
\alias{tv_dictionary}
\title{tv dictionary function}
\usage{
tv_dictionary(x, w, y, alpha, lambda, newx, family)
}
\arguments{
\item{x}{A matrix of variables to be selected by shrinkrage methods.}

\item{w}{Optional Argument. A matrix of variables to be selected by shrinkrage methods.}

\item{y}{the response variable.}

\item{alpha}{the alpha required in glmnet.}

\item{lambda}{the lambda required in glmnet.}

\item{newx}{Matrix  that selection will applied. Useful for time series, when we need the observation at time t.}

\item{family}{the glmnet family.}
}
\value{
X_star: a list with the coefficients and a matrix with the most predictive terms.
}
\description{
tv dictionary function
}
\examples{

set.seed(1)
data("stock_data")
data("news_data")
y=as.matrix(stock_data[1:200,2])
w=as.matrix(stock_data[1:200,3])
data("news_data")
X=news_data[1:200,2:ncol(news_data)]
x=as.matrix(X)
grid_alphas=seq(by=0.5,to=1,from=0.5)
cont_folds=TRUE
t=length(y)
optimal_alphas=optimal_alphas(x[1:(t-1),],w[1:(t-1),],
y[2:t],grid_alphas,TRUE,"gaussian")
x_star=tv_dictionary(x=x[1:(t-1),],w=w[1:(t-1),],y=y[2:t],
alpha=optimal_alphas[1],lambda=optimal_alphas[2],newx=x,family="gaussian")

}
