% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_one.R
\name{boot_one}
\alias{boot_one}
\title{Bootstrap sampling to calculate summary statistics of CTL values}
\arguments{
\item{data}{Data frame contains raw data. Must contain a column with a population
identifier (e.g. population ID), and a column containing critical
thermal limit data (e.g. temperatures at which critical limits are reached).}

\item{groups_col}{Factor. Column containing name(s) of population(s) of interest}

\item{groups_which}{Character. Which population should be analysed?}

\item{n_max}{Numeric. Maximum sample size to extrapolate simulations.}

\item{n_min}{Numeric. Minimum sample size to extrapolate simulations. Defaults to 3.}

\item{iter}{Numeric. Number of bootstrap samples. Defaults to 29.}

\item{response}{Numeric. Column containing thermal limit data for individual samples}
}
\value{
A data frame of CTL summary statistics from bootstrap resamples
}
\description{
Calculate mean and CI's of CTL for a single population
}
\examples{
\donttest{
head(coreid_data)
sims <- boot_one(data = coreid_data,
                    groups_col = col,
                    groups_which = "Catorhintha schaffneri_APM",
                    response = response,
                    n_max = 49,
                    iter = 99)
}
}
