% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-distribution-comparison.R
\name{tidy_distribution_comparison}
\alias{tidy_distribution_comparison}
\title{Compare Empirical Data to Distributions}
\usage{
tidy_distribution_comparison(.x, .distribution_type = "continuous")
}
\arguments{
\item{.x}{The data set being passed to the function}

\item{.distribution_type}{What kind of data is it, can be one of \code{continuous}
or \code{discrete}}
}
\value{
An invisible list object. A tibble is printed.
}
\description{
Compare some empirical data set against different distributions
to help find the distribution that could be the best fit.
}
\details{
The purpose of this function is to take some data set provided and
to try to find a distribution that may fit the best. A parameter of
\code{.distribution_type} must be set to either \code{continuous} or \code{discrete} in order
for this the function to try the appropriate types of distributions.

The following distributions are used:

Continuous:
\itemize{
\item tidy_beta
\item tidy_cauchy
\item tidy_exponential
\item tidy_gamma
\item tidy_logistic
\item tidy_lognormal
\item tidy_pareto
\item tidy_uniform
\item tidy_weibull
}

Discrete:
\itemize{
\item tidy_binomial
\item tidy_geometric
\item tidy_hypergeometric
\item tidy_poisson
}
}
\examples{
xc <- mtcars$mpg
tidy_distribution_comparison(xc, "continuous")

xd <- trunc(xc)
tidy_distribution_comparison(xd, "discrete")

}
\author{
Steven P. Sanderson II, MPH
}
\concept{Empirical}
