% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy-random-walk.R
\name{tidy_random_walk}
\alias{tidy_random_walk}
\title{Tidy Random Walk}
\usage{
tidy_random_walk(
  .data,
  .initial_value = 0,
  .sample = FALSE,
  .replace = FALSE,
  .value_type = "cum_prod"
)
}
\arguments{
\item{.data}{The data that is being passed from a \code{tidy_} distribution
function.}

\item{.initial_value}{The default is 0, this can be set to whatever you want.}

\item{.sample}{This is a boolean value TRUE/FALSE. The default is FALSE. If
set to TRUE then the \code{y} value from the \code{tidy_} distribution function is
sampled.}

\item{.replace}{This is a boolean value TRUE/FALSE. The default is FALSE. If
set to TRUE AND \code{.sample} is set to TRUE then the replace parameter of the
sample function will be set to TRUE.}

\item{.value_type}{This can take one of three different values for now. These
are the following:
\itemize{
\item "cum_prod" - This will take the cumprod of y
\item "cum_sum" - This will take the cumsum of y
}}
}
\value{
An ungrouped tibble.
}
\description{
Takes in the data from a \code{tidy_} distribution function and applies
a random walk calculation of either \code{cum_prod} or \code{cum_sum} to \code{y}.
}
\details{
Monte Carlo simulations were first formally designed in the 1940’s
while developing nuclear weapons, and since have been heavily used in various
fields to use randomness solve problems that are potentially deterministic in
nature. In finance, Monte Carlo simulations can be a useful tool to give a
sense of how assets with certain characteristics might behave in the future.
While there are more complex and sophisticated financial forecasting methods
such as ARIMA (Auto-Regressive Integrated Moving Average) and GARCH
(Generalised Auto-Regressive Conditional Heteroskedasticity) which attempt to
model not only the randomness but underlying macro factors such as seasonality
and volatility clustering, Monte Carlo random walks work surprisingly well in
illustrating market volatility as long as the results are not taken too
seriously.
}
\examples{
tidy_normal(.sd = .1, .num_sims = 25) \%>\%
  tidy_random_walk()

}
\author{
Steven P. Sanderson II, MPH
}
