% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trnorm.R
\name{Trnorm}
\alias{Trnorm}
\title{Separable Tensor Normal Distribution}
\usage{
Trnorm(n, m.vec, mu = array(0, m.vec), Sigma.list = NULL, type = "Chain",
  sd = 1, knn = 4, norm.type = 2)
}
\arguments{
\item{n}{number of generated observations.}

\item{m.vec}{vector of tensor mode dimensions, e.g., \code{m.vec=c(m1, m2, m3)} for a 3-mode tensor normal distribution.}

\item{mu}{array of mean for tensor normal distribution with dimension \code{m.vec}. Default is zero mean.}

\item{Sigma.list}{list of covariance matrices in mode sequence. Default is \code{NULL}.}

\item{type}{type of precision matrix, default is 'Chain'. Optional values are 'Chain' for 
triangle graph and 'Neighbor' for nearest-neighbor graph. Useless if \code{Sigma.list} is not \code{NULL}.}

\item{sd}{seed of random number generation, default is 1.}

\item{knn}{sparsity of precision matrix, i.e., matrix is generated from a \code{knn} nearest-neighbor graph. 
Default is 4. Useless if \code{type='Chain'} or \code{Sigma.list} is not \code{NULL}.}

\item{norm.type}{normalization method of precision matrix, i.e., \eqn{\Omega_{11} = 1}{\Omega_{11}=1} 
if norm.type = 1 and \eqn{\|\Omega\|_{F}=1}{||\Omega||_F =1 } if norm.type = 2. Default value is 2.}
}
\value{
An array with dimension m_1 * ... * m_K * n.
}
\description{
Generate observations from separable tensor normal distribution.
}
\details{
This function generates obeservations from separable tensor normal distribution and returns a \code{m1 * ... * mK * n} array. 
If \code{Sigma.list} is not given, default distribution is from either triangle graph or nearest-neighbor graph (depends on \code{type}).
}
\examples{
 
m.vec = c(5,5,5)  # dimensionality of a tensor 
n = 5   # sample size 
DATA=Trnorm(n,m.vec,type='Chain') 
# a 5*5*5*10 array of oberservation from 5*5*5 separable tensor 
#     normal distribtuion with mean zero and 
#         precision matrices from triangle graph

}
\author{
Will Wei Sun, Zhaoran Wang, Xiang Lyu, Han Liu, Guang Cheng.
}
\seealso{
\code{\link{ChainOmega}}, \code{\link{NeighborOmega}}
}

