% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gghues.R
\name{gghues}
\alias{gghues}
\title{Emulate ggplot2 default hues}
\usage{
gghues(n, start = 15)
}
\arguments{
\item{n}{The Numeric; number of hues to generate.}

\item{start}{Numeric; the place on the color wheel to start. ggplot2 default is 15.}
}
\value{
A vector of hues
}
\description{
This will emulate ggplot2's hues, which are equally spaced hues around the color wheel, starting from 15.
}
\examples{
n <- 10
barplot(1:n, col=gghues(n), main="ggplot2 defaults")
barplot(1:n, col=gghues(n, start=15+180), main="180 degree offset")

}
\author{
Stephen Turner
}
\keyword{keywords}

