% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_bindings.R
\name{pop_treat_var}
\alias{pop_treat_var}
\alias{set_pop_treat_var}
\title{Return or set pop_treat_var binding}
\usage{
pop_treat_var(table)

set_pop_treat_var(table, pop_treat_var)
}
\arguments{
\item{table}{A \code{tplyr_table} object}

\item{pop_treat_var}{Variable containing treatment group assignments within the \code{pop_data} binding. Supply unquoted.}
}
\value{
For \code{tplyr_pop_treat_var} the pop_treat_var binding of the
  \code{tplyr_table} object. For \code{set_tplyr_pop_treat_var} the modified
  object.
}
\description{
The treatment variable used in the target data may be different than the
variable within the population dataset. \code{set_pop_treat_var} allows you
to change this.
}
\examples{
tab <- tplyr_table(iris, Species)

pop_data(tab) <- mtcars
set_pop_treat_var(tab, mpg)

}
