% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_bindings.R
\name{set_total_row_label}
\alias{set_total_row_label}
\title{Set the label for the total row}
\usage{
set_total_row_label(e, total_row_label)
}
\arguments{
\item{e}{A \code{count_layer} object}

\item{total_row_label}{A character to label the total row}
}
\value{
The modified \code{count_layer} object
}
\description{
The row label for a total row defaults to "Total", however this can be
overriden using this function.
}
\examples{
# Load in pipe
library(magrittr)

t <- tplyr_table(mtcars, gear) \%>\%
  add_layer(
    group_count(cyl) \%>\%
      add_total_row() \%>\%
      set_total_row_label("Total Cyl")
  )
build(t)
}
