% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_templates.R
\name{new_layer_template}
\alias{new_layer_template}
\alias{remove_layer_template}
\alias{get_layer_template}
\alias{get_layer_templates}
\alias{use_template}
\title{Create, view, extract, remove, and use Tplyr layer templates}
\usage{
new_layer_template(name, template)

remove_layer_template(name)

get_layer_template(name)

get_layer_templates()

use_template(name, ..., add_params = NULL)
}
\arguments{
\item{name}{Template name}

\item{template}{Template layer syntax, starting with a layer constructor
\code{group_count|desc|shift}. This function should be called with an ellipsis
argument (i.e. group_count(...)).}

\item{...}{Arguments passed directly into a layer constructor, matching the
target, by, and where parameters.}

\item{add_params}{Additional parameters passed into layer modifier functions.
These arguments are specified in a template within curly brackets such as
{param}. Supply as a named list, where the element name is the parameter.}
}
\description{
There are several scenarios where a layer template may be useful. Some
tables, like demographics tables, may have many layers that will all
essentially look the same. Categorical variables will have the same count
layer settings, and continuous variables will have the same desc layer
settings. A template allows a user to build those settings once per layer,
then reference the template when the Tplyr table is actually built.
}
\details{
This suite of functions allows a user to create and use layer templates.
Layer templates allow a user to pre-build and reuse an entire layer
configuration, from the layer constructor down to all modifying functions.
Furthermore, users can specify parameters they may want to be
interchangeable. Additionally, layer templates are extensible, so a template
can be use and then further extended with additional layer modifying
functions.

Layers are created using \code{new_layer_template()}. To use a layer, use the
function \code{use_template()} in place of \code{group_count|desc|shift()}. If you want
to view a specific template, use \code{get_layer_template()}. If you want to view
all templates, use \code{get_layer_templates()}. And to remove a layer template use
\code{remove_layer_template()}. Layer templates themselves are stored in the
option \code{tplyr.layer_templates}, but a user should not access this directly
and instead use the Tplyr supplied functions.

When providing the template layer syntax, the layer must start with a layer
constructor. These are one of the function \code{group_count()}, \code{group_desc()},
or \code{group_shift()}. Instead of passing arguments into these function,
templates are specified using an ellipsis in the constructor, i.e.
\code{group_count(...)}. This is required, as after the template is built a user
supplies these arguments via \code{use_template()}

\code{use_template()} takes the \code{group_count|desc|shift()} arguments by default.
If a user specified additional arguments in the template, these are provided
in a list throught the argument \code{add_params}. Provide these arguments exactly
as you would in a normal layer. When creating the template, these parameters
can be specified by using curly brackets. See the examples for details.
}
\examples{

op <- options()

new_layer_template(
  "example_template",
  group_count(...) \%>\%
    set_format_strings(f_str('xx (xx\%)', n, pct))
)

get_layer_templates()

get_layer_template("example_template")

tplyr_table(mtcars, vs) \%>\%
  add_layer(
    use_template("example_template", gear)
  ) \%>\%
  build()

remove_layer_template("example_template")

new_layer_template(
  "example_template",
  group_count(...) \%>\%
    set_format_strings(f_str('xx (xx\%)', n, pct)) \%>\%
    set_order_count_method({sort_meth}) \%>\%
    set_ordering_cols({sort_cols})
)

get_layer_template("example_template")

tplyr_table(mtcars, vs) \%>\%
  add_layer(
    use_template("example_template", gear, add_params =
                   list(
                     sort_meth = "bycount",
                     sort_cols = `1`
                   ))
  ) \%>\%
  build()

remove_layer_template("example_template")

options(op)
}
\concept{Layer Templates}
