% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SampleEntropy.R
\name{SampleEntropy}
\alias{SampleEntropy}
\title{Sample Entropy}
\usage{
SampleEntropy(returns, m = 2, r = 0.2)
}
\arguments{
\item{returns}{a vector containing the track record of the underlying asset/strategy, these will be normalized during the algorithm}

\item{m}{an integer value defining the embedding dimension , default value is 2}

\item{r}{a  double  value defining the tolerance, default value is 0.2}
}
\value{
The sample Entropy of the input returns
}
\description{
Calculates the sample entropy of a track record. Sample entropy is an improvement of the approximate entropy and should produce accurate results
for timeseries of smaller length like historical returns of strategies
}
\examples{

## calling SampleEntropy() without an argument loads the historical edhec
## data for the "Short Selling" strategy
returns = PerformanceAnalytics::edhec[,c("Short Selling")]
Sample_Entropy = SampleEntropy(returns,m=2,r=0.2)

}
\references{
https://en.wikipedia.org/wiki/Sample_entropy
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
