% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genDataBeta.R
\name{genBetaMPT}
\alias{genBetaMPT}
\title{Generate Data for Beta MPT Models}
\usage{
genBetaMPT(N, numItems, eqnfile, restrictions, mean = NULL, sd = NULL,
  alpha = NULL, beta = NULL, warning = TRUE)
}
\arguments{
\item{N}{number of participants}

\item{numItems}{number of responses per tree (a named vector with tree labels)}

\item{eqnfile}{The (full path to the) file that specifies the MPT model (standard .eqn syntax). Note that category labels must start with a letter (different to multiTree) and match the column names of \code{data}. Alternatively, the EQN-equations can be provided within R as a character value (cf. \code{\link{readEQN}}). Note that the first line of an .eqn-file is reserved for comments and always ignored.}

\item{restrictions}{Specifies which parameters should be (a) constant (e.g., \code{"a=b=.5"}) or (b) constrained to be identical (e.g., \code{"Do=Dn"}) or (c) treated as fixed effects (i.e., identical for all participants; \code{"a=b=FE"}). Either given as the path to a text file with restrictions per row or as a list of restrictions, e.g., \code{list("D1=D2","g=0.5")}. Note that numbers in .eqn-equations (e.g., \code{d*(1-g)*.50}) are directly interpreted as equality constraints.}

\item{mean}{Named vector of true group means of individual MPT parameters. If the vector is not named, the internal order of parameters is used (can be obtained using \code{\link{readEQN}}).}

\item{sd}{named vector of group standard deviations of individual MPT parameters.}

\item{alpha}{Alternative specification of the group-level distribution using the shape parameters of the beta distribution (see \link{dbeta}).}

\item{beta}{see \code{alpha}

Data are generated independently from the JAGS model files used for fitting the Beta-MPT model. If data for an equality-constrained version of the MPT model are required, the restrictions need to be hard-coded into the EQN-model file. Note that equal means still result in nonidentical MPT parameters on the individual level!}

\item{warning}{whether to show warning in case the naming of arguments does not match}
}
\value{
a list including the generated frequencies (\code{data}) and the true, underlying parameters (\code{parameters})
}
\description{
Generating a data file with known parameter structure using the Beta-MPT. Useful for simulations and robustness checks.
}
\examples{
# Example: Standard Two-High-Threshold Model (2HTM)
EQNfile <- system.file("MPTmodels/2htm.eqn", package="TreeBUGS")
genDat <- genBetaMPT(N = 100,
                     numItems = c(Target=250, Lure=250),
                     eqnfile = EQNfile,
                     mean = c(Do=.7, Dn=.5, g=.5),
                     sd =   c(Do=.1, Dn=.1, g=.05))
head(genDat$data, 3)
plotFreq(genDat$data, eqn=EQNfile)
}
\references{
Smith, J. B., & Batchelder, W. H. (2010). Beta-MPT: Multinomial processing tree models for addressing individual differences. Journal of Mathematical Psychology, 54, 167-183.
}
\seealso{
\code{\link{genMPT}}
}
