% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lap.R
\name{LAPJV}
\alias{LAPJV}
\title{Solve linear assignment problem using LAPJV}
\usage{
LAPJV(x)
}
\arguments{
\item{x}{Square matrix of costs.}
}
\value{
A list with two entries: \code{score}, the score of the optimal matching;
and \code{matching}, the columns matched to each row of the matrix in turn.
}
\description{
Use the algorithm of Jonker & Volgenant (1987) to solve the
\href{http://www.assignmentproblems.com/doc/LSAPIntroduction.pdf}{Linear Sum Assignment Problem}.
}
\details{
The Linear Assignment Problem seeks to match each row of a matrix with a
column, such that the cost of the matching is minimized.

The Jonker & Volgenant approach is a faster alternative to the Hungarian
algorithm (Munkres 1957), which is implemented in \code{clue::solve_LSAP()}.

NB. At present, only square matrices are supported; if you need support for
non-square matrices, drop a note at
\href{https://github.com/ms609/TreeDist/issues/25}{issue #25}
and I'll prioritize development.
}
\examples{
problem <- matrix(c(7, 9, 8, 9,
                    2, 8, 5, 7,
                    1, 6, 6, 9,
                    3, 6, 2, 2), 4, 4, byrow=TRUE)

LAPJV(problem)
}
\references{
\insertRef{Jonker1987}{TreeDist}

\insertRef{Munkres1957}{TreeDist}
}
\author{
\href{https://github.com/yongyanghz/LAPJV-algorithm-c/blob/master/LAPJV/lap.cpp}{C++ code}
by Roy Jonker, MagicLogic Optimization Inc. \href{mailto:roy_jonker@magiclogic.com}{roy_jonker@magiclogic.com},
with contributions from Yong Yang \href{mailto:yongyanglink@gmail.com}{yongyanglink@gmail.com}, after
\href{https://uk.mathworks.com/matlabcentral/profile/authors/69713-yi-cao}{Yi Cao}
}
