% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{tlsRotate}
\alias{tlsRotate}
\title{Rotate point cloud towards a horizontal plane}
\usage{
tlsRotate(las)
}
\arguments{
\item{las}{\code{LAS} object.}
}
\value{
\code{LAS} object.
}
\description{
Check for ground points and rotates the point cloud to align its ground surface to a horizontal plane (XY).
This function is especially useful for point clouds not georreferenced or generated through mobile scanning,
which might present a tilted global reference system. Since the coordinates are altered in this procedure, any
geographical information is erased from the LAS' header after rotation.
}
\examples{
file = system.file("extdata", "pine_plot.laz", package="TreeLS")
tls = readTLS(file)

### note the tilted ground
plot(tls)
rgl::axes3d(col='white')

### after rotation
tls = tlsRotate(tls)
plot(tls)
rgl::axes3d(col='white')

}
