% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{cylinderFit}
\alias{cylinderFit}
\title{Point cloud cylinder fit}
\usage{
cylinderFit(
  las,
  method = "ransac",
  n = 5,
  inliers = 0.9,
  conf = 0.95,
  max_angle = 30,
  n_best = 20
)
}
\arguments{
\item{las}{\code{\link[lidR:LAS]{LAS}} object.}

\item{method}{method for estimating the cylinder parameters. Currently available: \code{"nm"}, \code{"irls"}, \code{"ransac"} and \code{"bf"}.}

\item{n}{\code{numeric} - number of points selected on every RANSAC iteration.}

\item{inliers}{\code{numeric} - expected proportion of inliers among stem segments' point cloud chunks.}

\item{conf}{\code{numeric} - confidence level.}

\item{max_angle}{\code{numeric} - used when \code{method == "bf"}. The maximum tolerated deviation, in degrees, from an absolute vertical line (Z = c(0,0,1)).}

\item{n_best}{\code{integer} - estimate optimal RANSAC parameters as the median of the \code{n_best} estimations with lowest error.}
}
\value{
vector of parameters
}
\description{
Fits a cylinder on a set of 3D points.
}
