% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{stemPoints}
\alias{stemPoints}
\title{Stem points classification}
\usage{
stemPoints(las, method = stm.hough())
}
\arguments{
\item{las}{\code{\link[lidR:LAS]{LAS}} object.}

\item{method}{stem denoising algorithm. Currently available: \code{\link{stm.hough}}, \code{\link{stm.eigen.knn}} and \code{\link{stm.eigen.voxel}}.}
}
\value{
\code{\link[lidR:LAS]{LAS}} object.
}
\description{
Classify stem points of all trees in a \strong{normalized} point cloud. Stem denoising methods are prefixed by \code{stm}.
}
\examples{
### single tree
file = system.file("extdata", "spruce.laz", package="TreeLS")
tls = readTLS(file) \%>\%
  tlsNormalize \%>\%
  stemPoints(stm.hough(h_base = c(.5,2)))
plot(tls, color='Stem')

### entire forest plot
file = system.file("extdata", "pine_plot.laz", package="TreeLS")
tls = readTLS(file) \%>\%
  tlsNormalize \%>\%
  tlsSample

map = treeMap(tls, map.hough())
tls = treePoints(tls, map, trp.crop(circle=FALSE))
tls = stemPoints(tls, stm.hough(pixel_size = 0.03))
tlsPlot(tls)
}
