% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{treePoints}
\alias{treePoints}
\title{Classify individual tree regions in a point cloud}
\usage{
treePoints(las, map, method = trp.voronoi())
}
\arguments{
\item{las}{\code{\link[lidR:LAS]{LAS}} object.}

\item{map}{object generated by \code{\link{treeMap}}.}

\item{method}{tree region algorithm. Currently available: \code{\link{trp.voronoi}} and \code{\link{trp.crop}}.}
}
\value{
\code{\link[lidR:LAS]{LAS}} object.
}
\description{
Assigns \code{TreeID}s to a \code{LAS} object based on coordinates extracted from a
\code{\link{treeMap}} object. Tree region segmentation methods are prefixed by \code{trp}.
}
\examples{
file = system.file("extdata", "pine_plot.laz", package="TreeLS")
tls = readTLS(file) \%>\%
  tlsNormalize \%>\%
  tlsSample

map = treeMap(tls, map.hough())
tls = treePoints(tls, map, trp.crop(circle=FALSE))

x = plot(tls, size=1)
add_treePoints(x, tls, size=2)
add_treeIDs(x, tls, color='yellow', cex=2)
}
