% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShapeFile.R
\name{ReadShapefile_TreeRingPoints}
\alias{ReadShapefile_TreeRingPoints}
\title{Read a shape file of Tree Ring Points ( P : radial input and correction points)}
\usage{
ReadShapefile_TreeRingPoints(
  filename = "Abies_277_h400_TreeRing_Points.shp",
  id.tag = "id",
  ring.tag = "ring"
)
}
\arguments{
\item{filename}{a file name of Tree ring points (shape file )}

\item{id.tag}{string, column name of id (attribute table)}

\item{ring.tag}{string, column name of ring years  (0 is cambium layer)}
}
\value{
a data frame of TreeRingPoints (radial input and correction points)
}
\description{
Read a shape file of Tree Ring Points ( P : radial input and correction points)
}
\examples{

.dir <- system.file("shp",package = "TreeRingShape")
.file <- "Abies_277_h400_TreeRing_Points.shp"
filename <- paste(.dir,.file,sep="/")
sf.P<-sf::st_read(filename)
plot(sf.P)
ReadShapefile_TreeRingPoints(filename,id.tag='id',ring.tag='ring')
}
