% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_numbering.R
\name{Cladewise}
\alias{Cladewise}
\alias{Postorder}
\alias{PostorderEdges}
\alias{Pruningwise}
\alias{Preorder}
\title{Reorder tree Cladewise}
\usage{
Cladewise(tree, nTaxa = NULL, edge = tree$edge)

Postorder(tree, nTaxa = length(tree$tip.label), edge = tree$edge)

PostorderEdges(parent, child, nEdge = length(parent), nNode = nEdge/2L,
  nTaxa = nNode + 1L)

Pruningwise(tree, nTaxa = length(tree$tip.label), edge = tree$edge)

Preorder(tree)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}.}

\item{nTaxa}{(optional) number of tips in the tree}

\item{edge}{(optional) the value of tree$edge}

\item{parent}{the first column of the edge matrix of a tree of class
\code{\link{phylo}}, i.e. \code{tree$edge[, 1]}}

\item{child}{the second column of the edge matrix of a tree of class
\code{\link{phylo}}, i.e. \code{tree$edge[, 2]}}

\item{nTaxa}{Number of terminal taxa in tree.}
}
\value{
A tree with nodes numbered in postorder
}
\description{
A wrapper for \code{ape:::.reorder_ape}.  Calling this C function directly is approximately twice as fast as using
\code{ape::\link[ape]{cladewise}} or \code{ape::\link[ape]{postorder}}
}
\section{Functions}{
\itemize{
\item \code{Postorder}: Reorder tree in Postorder

\item \code{PostorderEdges}: Reorder parent and child edges in Postorder

\item \code{Pruningwise}: Reorder tree Pruningwise

\item \code{Preorder}: Reorder tree in Preorder (special case of cladewise)
}}

\author{
Modified by Martin R. Smith from \code{.reorder_ape} in \pkg{ape} (Emmanuel Paradis)
}
\keyword{internal}
