% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_distance.R
\name{MatchingSplitDistance}
\alias{MatchingSplitDistance}
\alias{MatchingSplitDistanceSplits}
\title{Matching Split Distance}
\usage{
MatchingSplitDistance(tree1, tree2, reportMatching = FALSE)

MatchingSplitDistanceSplits(splits1, splits2, reportMatching = FALSE)
}
\arguments{
\item{tree1}{Trees of class \code{phylo}, with tips labelled identically,
or lists of such trees to undergo pairwise comparison.}

\item{tree2}{Trees of class \code{phylo}, with tips labelled identically,
or lists of such trees to undergo pairwise comparison.}

\item{reportMatching}{Logical specifying whether to return the clade
matchings as an attribute of the score.}

\item{splits1}{Logical matrices where each row corresponds to a terminal,
either listed in the same order or bearing identical names (in any sequence),
and each column corresponds to a bipartition split, such that
each terminal is identified as a member of the ingroup (\code{TRUE}) or outgroup
(\code{FALSE}) of the respective bipartition split.}

\item{splits2}{Logical matrices where each row corresponds to a terminal,
either listed in the same order or bearing identical names (in any sequence),
and each column corresponds to a bipartition split, such that
each terminal is identified as a member of the ingroup (\code{TRUE}) or outgroup
(\code{FALSE}) of the respective bipartition split.}
}
\description{
Implements the Matching Split Distance for unrooted binary phylogenetic
trees of Bogdanowicz and Giaro (2012).
}
\section{Functions}{
\itemize{
\item \code{MatchingSplitDistanceSplits}: Takes splits instead of trees
}}

\references{
\insertRef{Bogdanowicz2012}{TreeSearch}
}
\author{
Martin R. Smith
}
\concept{Tree distance}
