% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpl_morphyex.R
\name{mpl_second_down_recon}
\alias{mpl_second_down_recon}
\title{Performs the second nodal reconstructions for characters with
inapplicability.}
\usage{
mpl_second_down_recon(node_id, left_id, right_id, morphyobj)
}
\arguments{
\item{node_id}{The index of the node being reconstructed.}

\item{left_id}{The index of the left descendant.}

\item{right_id}{The index of the right descendant.}

\item{morphyobj}{An instance of the Morphy object.}

\item{anc_id}{The index of the immediate ancestor of the node.}
}
\value{
The integral parsimony length (right now)
}
\description{
Updates the nodal sets that had ambiguous unions with the
inapplicable state and calculates steps involving applicable states after
the update.
Because this function needs to be fairly high-performance, it does not do much
checking for parameter validity, thus unsafe usage of this function might not
be caught. It is up to calling functions to ensure that the appropriate
parameters have been set before use.
}
\author{
Thomas Guillerme
}
\keyword{internal}
