% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fitch.R
\name{Fitch}
\alias{Fitch}
\title{Calculate parsimony score with inapplicable data}
\usage{
Fitch(tree, dataset)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}.}

\item{dataset}{A phylogenetic data matrix of class \code{\link[phangorn]{phyDat}},
whose names correspond to the labels of any accompanying tree.}
}
\value{
\code{Fitch()} returns the elements from a list containing:
\itemize{
\item     The total parsimony score
\item     The parsimony score associated with each character
\item     A matrix comprising character reconstructions for each node
after the final pass
}
The elements to return are specified by the parameter \code{detail}.
If a single element is requested (default) then just that element will be returned
If multiple elements are requested then these will be returned in a list.
}
\description{
Uses code modified from the Morphy library to calculate a
parsimony score in datasets that contain inapplicable data.
}
\examples{
data("inapplicable.datasets")
tree <- TreeTools::BalancedTree(inapplicable.phyData[[1]])
Fitch(tree, inapplicable.phyData[[1]])
}
\seealso{
\itemize{
\item \code{\link[=TreeSearch]{TreeSearch()}}
}

Other tree scoring: 
\code{\link{CharacterLength}()},
\code{\link{IWScore}()},
\code{\link{MorphyTreeLength}()}
}
\author{
Martin R. Smith (using Morphy C library, by Martin Brazeau)
}
\concept{tree scoring}
