% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CustomSearch.R, R/IWScore.R,
%   R/TreeSearch_utilities.R
\name{EdgeListSearch}
\alias{EdgeListSearch}
\alias{TreeSearch}
\alias{IWTreeSearch}
\alias{EmptyPhyDat}
\alias{DoNothing}
\title{Search for most parsimonious trees}
\usage{
EdgeListSearch(
  edgeList,
  dataset,
  TreeScorer = MorphyLength,
  EdgeSwapper = RootedTBRSwap,
  maxIter = 100,
  maxHits = 20,
  bestScore = NULL,
  stopAtScore = NULL,
  stopAtPeak = FALSE,
  stopAtPlateau = 0L,
  verbosity = 1L,
  ...
)

TreeSearch(
  tree,
  dataset,
  InitializeData = PhyDat2Morphy,
  CleanUpData = UnloadMorphy,
  TreeScorer = MorphyLength,
  EdgeSwapper = RootedTBRSwap,
  maxIter = 100L,
  maxHits = 20L,
  stopAtPeak = FALSE,
  stopAtPlateau = 0L,
  verbosity = 1L,
  ...
)

IWTreeSearch(...)

EmptyPhyDat(tree)

DoNothing(...)
}
\arguments{
\item{edgeList}{a list containing the following:
- vector of integers corresponding to the parent of each edge in turn
- vector of integers corresponding to the child of each edge in turn
- (optionally) score of the tree
- (optionally, if score provided) number of times this score has been hit}

\item{dataset}{A phylogenetic data matrix of \pkg{phangorn} class
\code{phyDat}, whose names correspond to the labels of any accompanying tree.}

\item{TreeScorer}{function to score a given tree.
The function will be passed three parameters, corresponding to the
\code{parent} and \code{child} entries of a tree's edge list, and a dataset.}

\item{EdgeSwapper}{a function that rearranges a parent and child vector,
and returns a list with modified vectors; for example \code{\link[=SPRSwap]{SPRSwap()}}.}

\item{maxIter}{Numeric specifying maximum number of iterations to perform
before abandoning the search.}

\item{maxHits}{Numeric specifying maximum times to hit the best pscore
before abandoning the search.}

\item{stopAtPeak}{Logical specifying whether to terminate search once a
subsequent iteration recovers a sub-optimal score.
Will be overridden if a passed function has an attribute \code{stopAtPeak} set by
\code{attr(FunctionName, 'stopAtPeak') <- TRUE}.}

\item{stopAtPlateau}{Integer. If > 0, tree search will terminate if the score
has not improved after \code{stopAtPlateau} iterations.
Will be overridden if a passed function has an attribute \code{stopAtPlateau} set
by \code{attr(FunctionName, 'stopAtPlateau') <- TRUE}.}

\item{verbosity}{Numeric specifying level of detail to display in console:
larger numbers provide more verbose feedback to the user.}

\item{\dots}{further arguments to pass to \code{TreeScorer()}, e.g. \verb{dataset = }.}

\item{tree}{A fully-resolved starting tree in \code{\link{phylo}} format,
with the desired outgroup.
Edge lengths are not supported and will be removed.}

\item{InitializeData}{Function that sets up data object to prepare for tree search.
The function will be passed the \code{dataset} parameter.
Its return value will be passed to \code{TreeScorer()} and \code{CleanUpData()}.}

\item{CleanUpData}{Function to destroy data object on function exit.
The function will be passed the value returned by \code{InitializeData()}.}
}
\value{
\code{TreeSearch()} returns a tree, with an attribute \code{pscore} conveying its
parsimony score.
#' Note that the parsimony score will be inherited from the tree's
attributes, which is only valid if it was generated using the same
\code{data} that is passed here.

\code{EmptyPhyDat()} returns a \code{phyDat} object comprising a single
null character, coded with state zero for every leaf in \code{tree}.
}
\description{
Run standard search algorithms (\acronym{NNI}, \acronym{SPR} or \acronym{TBR})
to search for a more parsimonious tree.

For detailed documentation of the 'TreeSearch' package, including full
instructions for loading phylogenetic data into R and initiating and
configuring tree search, see the
\href{https://ms609.github.io/TreeSearch/}{package documentation}.
}
\section{Functions}{
\itemize{
\item \code{EdgeListSearch}: Tree search from edge lists
}}

\examples{
data('Lobo', package='TreeTools')
njtree <- TreeTools::NJTree(Lobo.phy)

## Only run examples in interactive R sessions
if (interactive()) {
  TreeSearch(njtree, Lobo.phy, maxIter = 20, EdgeSwapper = NNISwap)
  TreeSearch(njtree, Lobo.phy, maxIter = 20, EdgeSwapper = RootedSPRSwap)
  TreeSearch(njtree, Lobo.phy, maxIter = 20, EdgeSwapper = TBRSwap)
}
}
\seealso{
\itemize{
\item \code{\link{Fitch}}, calculates parsimony score;
\item \code{\link{RootedNNI}}, conducts tree rearrangements;
\item \code{\link{Ratchet}}, alternative heuristic, useful to escape local
optima.
}

Other custom search functions: 
\code{\link{Jackknife}()},
\code{\link{MorphyBootstrap}()},
\code{\link{SuccessiveApproximations}()}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{custom search functions}
\keyword{internal}
