% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TipTimedTree.R
\name{TipTimedTree}
\alias{TipTimedTree}
\title{Display time-calibrated tree using tip information only}
\usage{
TipTimedTree(tree, tipAge, minEdge = 1)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}

\item{tipAge}{Numeric vector specifying the age (in units-of-time ago)
associated with each tip in \code{tree$tip.label} in turn.
Older ages signify earlier tips.}

\item{minEdge}{Minimum length of edge to allow (in units-of-time)}
}
\value{
\code{TipTimedTree()} returns a tree with edge lengths set based on the
ages of each tip.
}
\description{
\code{TipTimedTree()} plots a phylogenetic tree against time using an
\emph{ad hoc} approach based on dates associated with the leaves.
Nodes are dated to the youngest possible value, plus an additional "buffer"
(specified with \code{minEdge}) to ensure that branching order is readable.
}
\details{
This experimental function is liable to change its behaviour, or to
be deprecated, in coming releases.
Please contact the maintainer if you find it useful, so that a
production-ready version can be prioritized.
}
\examples{
tree <- BalancedTree(6)
plot(TipTimedTree(tree, tipAge = 1:6, minEdge = 2))
}
\seealso{
Other tree manipulation: 
\code{\link{AddTip}()},
\code{\link{CollapseNode}()},
\code{\link{ConsensusWithout}()},
\code{\link{DropTip}()},
\code{\link{EnforceOutgroup}()},
\code{\link{ImposeConstraint}()},
\code{\link{KeptPaths}()},
\code{\link{KeptVerts}()},
\code{\link{LeafLabelInterchange}()},
\code{\link{MakeTreeBinary}()},
\code{\link{RenumberTips}()},
\code{\link{RenumberTree}()},
\code{\link{Renumber}()},
\code{\link{RootTree}()},
\code{\link{SortTree}()},
\code{\link{Subtree}()},
\code{\link{TrivialTree}}
}
\concept{tree manipulation}
\concept{utility functions}
