% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Splits.R
\name{edge_to_splits}
\alias{edge_to_splits}
\title{Efficiently convert edge matrix to splits}
\usage{
edge_to_splits(
  edge,
  edgeOrder,
  tipLabels = NULL,
  asSplits = TRUE,
  nTip = NTip(edge),
  ...
)
}
\arguments{
\item{edge}{A matrix with two columns, with each row listing the parent and
child node of an edge in a phylogenetic tree.  Property \code{edge} of objects
of class \code{phylo}.}

\item{edgeOrder}{Integer vector such that \code{edge[edgeOrder, ]} returns a
postorder ordering of edges.}

\item{tipLabels}{Character vector specifying sequence in which to order
tip labels.  Label order must (currently) match to combine or compare separate
\code{Splits} objects.}

\item{asSplits}{Logical specifying whether to return a \code{Splits} object,
or an unannotated two-dimensional array (useful where performance is
paramount).}

\item{nTip}{Integer specifying number of leaves in tree.}

\item{...}{Presently unused.}
}
\value{
\code{edge_to_splits()} uses the same return format as \code{as.Splits()}.
}
\description{
Wrapper for internal C++ function for maximum efficiency.
Improper input may crash R.  Behaviour not guaranteed.
It is advisable to contact the package maintainers before
relying on this function.
}
\seealso{
\code{\link[=Splits]{as.Splits()}} offers a safe access point to this
function that should be suitable for most users.
}
\concept{C++ wrappers}
