% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_properties.R
\name{NodeOrder}
\alias{NodeOrder}
\title{Number of edges incident to each node in a tree}
\usage{
NodeOrder(x, includeAncestor = TRUE, internalOnly = FALSE)
}
\arguments{
\item{x}{A tree of class \code{phylo}, its \verb{$edge} property, or a list thereof.}

\item{includeAncestor}{Logical specifying whether to count edge leading to
ancestral node in calculation of order.}

\item{internalOnly}{Logical specifying whether to restrict to results
to internal nodes, i.e. to omit leaves. Irrelevant if
\code{includeAncestor = FALSE}.}
}
\value{
\code{NodeOrder()} returns an integer listing the order of each node;
entries are named with the number of each node.
}
\description{
\code{NodeOrder()} calculates the order of each node: the number of edges
incident to it in a tree.
This value includes the root edge in rooted trees.
}
\examples{
tree <- CollapseNode(BalancedTree(8), 12:15)
NodeOrder(tree)
plot(tree)
nodelabels(NodeOrder(tree, internalOnly = TRUE))

}
\seealso{
Other tree navigation: 
\code{\link{AncestorEdge}()},
\code{\link{CladeSizes}()},
\code{\link{DescendantEdges}()},
\code{\link{EdgeAncestry}()},
\code{\link{EdgeDistances}()},
\code{\link{ListAncestors}()},
\code{\link{MRCA}()},
\code{\link{MatchEdges}()},
\code{\link{NDescendants}()},
\code{\link{NodeDepth}()},
\code{\link{NodeNumbers}()},
\code{\link{RootNode}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree navigation}
