% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TempWindProfileFunctions.R
\name{air_temp_profile}
\alias{air_temp_profile}
\title{Air Temperature Profile using MICRO Routine}
\usage{
air_temp_profile(T_r, u_r, zr, z0, z, T_s)
}
\arguments{
\item{T_r}{\code{numeric} air temperature (C) at reference height.}

\item{u_r}{\code{numeric} windspeed (\ifelse{html}{\out{m s<sup>-1</sup>}}{\eqn{m s^-1}{ASCII}}) at reference height.}

\item{zr}{\code{numeric} initial reference height (m).}

\item{z0}{\code{numeric} surface roughness (m).}

\item{z}{\code{numeric} height to scale (m).}

\item{T_s}{\code{numeric} surface temperatures (C).}
}
\value{
\code{numeric} air temperature (C).
}
\description{
The function estimates air temperature (C) at a specified height (m). Estimates a single, unsegmented temperature profile using the MICRO routine from NicheMapR \insertCite{Kearney2017}{TrenchR}.
}
\examples{
  air_temp_profile(T_r = 20,
                   u_r = 0.1, 
                   zr  = 0.1, 
                   z0  = 0.2, 
                   z   = 0.15, 
                   T_s = 25)

}
\references{
\insertAllCited{}
}
\seealso{
Other microclimate functions: 
\code{\link{air_temp_profile_neutral}()},
\code{\link{air_temp_profile_segment}()},
\code{\link{degree_days}()},
\code{\link{direct_solar_radiation}()},
\code{\link{diurnal_radiation_variation}()},
\code{\link{diurnal_temp_variation_sineexp}()},
\code{\link{diurnal_temp_variation_sinesqrt}()},
\code{\link{diurnal_temp_variation_sine}()},
\code{\link{monthly_solar_radiation}()},
\code{\link{partition_solar_radiation}()},
\code{\link{proportion_diffuse_solar_radiation}()},
\code{\link{solar_radiation}()},
\code{\link{surface_roughness}()},
\code{\link{wind_speed_profile_neutral}()},
\code{\link{wind_speed_profile_segment}()}
}
\concept{microclimate functions}
