% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.list.R
\name{data.frame.to.list}
\alias{data.frame.to.list}
\title{Convert a list of vectors to a data frame.}
\usage{
data.frame.to.list(...)
}
\arguments{
\item{...}{other parameters passed to \code{\link{data.frame}}.}
}
\value{
a data frame.
}
\description{
This function will convert a list of vectors to a data frame. This function
will handle three different types of lists of vectors. First, if all the elements
in the list are named vectors, the resulting data frame will have have a number
of columns equal to the number of unique names across all vectors. In cases
where some vectors do not have names in other vectors, those values will be
filled with \code{NA}.
}
\details{
The second case is when all the vectors are of the same length. In this case,
the resulting data frame is equivalent to applying \code{rbind} across all elements.

The third case handled is when there are varying vector lengths and not all the
vectors are named. This condition should be avoided. However, the function will
attempt to convert this list to a data frame. The resulting data frame will have
a number of columns equal to the length of the longest vector. For vectors with
length less than this will fill the row with \code{NA}s. Note that this function
will print a warning if this condition occurs.
}
\references{
\url{http://stackoverflow.com/questions/4227223/r-list-to-data-frame}
}
