% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELEFAN.R
\name{ELEFAN}
\alias{ELEFAN}
\title{ELEFAN}
\usage{
ELEFAN(param, Linf_fix = NA, Linf_range = NA, K_range = exp(seq(log(0.1),
  log(10), length.out = 100)), C = 0, WP = 0, MA = 5, addl.sqrt = FALSE,
  plot = FALSE)
}
\arguments{
\item{param}{a list consisting of following parameters:
\itemize{
  \item \strong{midLengths} midpoints of the length classes,
  \item \strong{dates} dates of sampling times (class Date),
  \item \strong{catch} matrix with catches/counts per length class (row) and sampling date (column);
}}

\item{Linf_fix}{numeric; if used the K-Scan method is applied with a fixed Linf value (i.e. varying K only).}

\item{Linf_range}{numeric vector with potential Linf values. Default is the last length class plus/minus 5 cm}

\item{K_range}{K values for which the score of growth functions should be calculated
(by default: exp(seq(log(0.1),log(10),length.out = 100)))}

\item{C}{growth oscillation amplitude (default: 0)}

\item{WP}{winter point (default: 0)}

\item{MA}{number indicating over how many length classes the moving average should be performed (defalut: 5, for
more information see \link{lfqRestructure}).}

\item{addl.sqrt}{Passed to \link{lfqRestructure}. Applied an additional square-root transformation of positive values according to Brey et al. (1988).
(default: FALSE, for more information see \link{lfqRestructure}).}

\item{plot}{logical; indicating if plot with restrucutred frequencies and growth curves should
be displayed}
}
\value{
A list with the input parameters and following list objects:
\itemize{
  \item \strong{samplingPeriod}: length of sampling period in years,
  \item \strong{samplingDays}: time of sampling times in relation to first sampling time,
  \item \strong{delta_t}: array with time differences between relative sampling time set to zero and
     other sampling times,
  \item \strong{rcounts}: restructured frequencies,
  \item \strong{peaks_mat}: matrix with positive peaks with distinct values,
  \item \strong{ASP}: available sum of peaks, sum of posititve peaks which could be potential be hit by
     growth curves,
  \item \strong{score_mat}: matrix with scores for each Linf (only Linf_fix) and K combination,
  \item \strong{ESP_starting_point_L}: array with best starting points for each Linf
     (only Linf_fix) and K combination,
  \item \strong{C}: amplitude of growth oscillation,
  \item \strong{WP}: winter point winter point (WP = ts + 0.5);
when the K-Scan method is applied (fixed Linf) in addition following parameters:
  \item \strong{Rn_max}: highest score value,
  \item \strong{Linf_fix}: fixed Linf (asymptotic length of VBGF),
  \item \strong{K_opt}: curving factor (of VBGF, K) which returns best score,
  \item \strong{startingPoints}: starting sample and starting length yielding in best fit;
}
}
\description{
Electronic LEngth Frequency ANalysis for estimating growth parameter.
}
\details{
This functions allows to perform the K-Scan and Response surface analysis to estimate growth parameters.
   It combines the step of restructuring length-frequency data (\link{lfqRestructure}) followed by the fitting of VBGF
   curves through the restructured data (\link{lfqFitCurves}). K-Scan is a method used to search for the K
   parameter with the best fit while keeping the Linf fixed. In contrast, with response surface analysis
   both parameters are estimated and the fits are displayed in a heatmap.
}
\examples{
data(trout)

# K-Scan
ELEFAN(trout, Linf_fix = 16)

# Surface response analysis
ELEFAN(trout, K_range = seq(0.1,2,0.1), Linf_range = seq(12,17,1))

# ELEFAN(trout) # default settings using fine-resolution intervals

}
\references{
Brey, T., Soriano, M., and Pauly, D. 1988. Electronic length frequency analysis: a revised and expanded
user's guide to ELEFAN 0, 1 and 2.

Pauly, D. 1981. The relationship between gill surface area and growth performance in fish:
a generalization of von Bertalanffy's theory of growth. \emph{Meeresforsch}. 28:205-211

Pauly, D. and N. David, 1981. ELEFAN I, a BASIC program for the objective extraction of
growth parameters from length-frequency data. \emph{Meeresforschung}, 28(4):205-211

Pauly, D., 1985. On improving operation and use of ELEFAN programs. Part I: Avoiding
"drift" of K towards low values. \emph{ICLARM Conf. Proc.}, 13-14

Pauly, D., 1987. A review of the ELEFAN system for analysis of length-frequency data in
fish and aquatic invertebrates. \emph{ICLARM Conf. Proc.}, (13):7-34

Pauly, D. and G. R. Morgan (Eds.), 1987. Length-based methods in fisheries research.
(No. 13). WorldFish

Pauly, D. and G. Gaschuetz. 1979. A simple method for fitting oscillating length growth data, with a
program for pocket calculators. I.C.E.S. CM 1979/6:24. Demersal Fish Cttee, 26 p.

Pauly, D. 1984. Fish population dynamics in tropical waters: a manual for use with programmable
calculators (Vol. 8). WorldFish.

Quenouille, M. H., 1956. Notes on bias in estimation. \emph{Biometrika}, 43:353-360

Somers, I. F., 1988. On a seasonally oscillating growth function. ICLARM Fishbyte 6(1): 8-11.

Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2): 407 p.

Tukey, J., 1958. Bias and confidence in not quite large samples.
\emph{Annals of Mathematical Statistics}, 29: 614

Tukey, J., 1986. The future of processes of data analysis. In L. V. Jones (Eds.),
The Collected Works of John W. Tukey-philosophy and principles of data analysis:
1965-1986 (Vol. 4, pp. 517-549). Monterey, CA, USA: Wadsworth & Brooks/Cole
}

