% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TruncExpFam-package.R
\docType{package}
\name{TruncExpFam}
\alias{TruncExpFam-package}
\alias{TruncExpFam}
\title{Truncated Exponential Family}
\description{
TruncExpFam is an R package to handle truncated members from the
exponential family.
}
\details{
This package offers truncated counterparts of the density-,
distribution-, quantile- and sampling-functions for a broad range of
distributions from the exponential family, as implemented in the \link{stats}
package.

The package also provides functions for estimating the parameters of the
distributions from data, given the truncation limits.

For more info, please check \code{\link[=rtrunc]{rtrunc()}}, \code{\link[=dtrunc]{dtrunc()}} and \code{\link[=print.trunc]{print.trunc()}}.
Counterparts for density and probability functions are on the roadmap for
a future release.
}
\note{
Found a bug? Want to suggest a feature? Contribute to the scientific
and open source communities by opening an issue on our home page.
Check the "BugReports" field on \code{packageDescription("TruncExpFam")} for
the URL.
}
\section{Supported distributions}{

\itemize{
\item Beta
\item Binomial
\item Chi-Square
\item Continuous Bernoulli
\item Exponential
\item Gamma
\item Inverse Gamma
\item Inverse Gaussian
\item Log-normal
\item Negative Binomial
\item Normal
\item Poisson
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://ocbe-uio.github.io/TruncExpFam/}
  \item Report bugs at \url{https://github.com/ocbe-uio/TruncExpFam/issues}
}

}
\author{
\strong{Maintainer}: Waldir Leoncio \email{w.l.netto@medisin.uio.no}

Authors:
\itemize{
  \item René Holst \email{rene.holst@medisin.uio.no}
}

}
