% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norminvp.R
\name{norminvp}
\alias{norminvp}
\title{Normal quantile function (high precision)}
\usage{
norminvp(p, l, u)
}
\arguments{
\item{p}{quantile  at \eqn{0\le p\le 1}}

\item{l}{lower truncation limit}

\item{u}{upper truncation limit}
}
\value{
quantile value of the truncated normal distribution.
}
\description{
Computes with tail-precision the quantile function
 of the standard normal distribution at \eqn{0\le p\le 1},
 and truncated to the interval \eqn{[l,u]}.
Infinite values for vectors \eqn{l} and \eqn{u} are accepted.
}
\details{
Suppose we wish to simulate a random variable \eqn{Z} drawn from \eqn{N(\mu,\sigma^2)} and
 conditional on \eqn{l<Z<u} using the inverse transform method.
 To achieve this, first compute
 \code{X=norminvp(runif(1),(l-mu)/sig,(u-mu)/sig)} and then set
 \code{Z=mu+sig*X}
}
\note{
If you wish to simulate truncated normal variables fast, use \code{\link{trandn}}.
 Using \code{norminvp}  is advisable only when needed, for example,
 in quasi-Monte Carlo or antithetic sampling, where the inverse transform method
 is unavoidable.
}
\examples{
 d <- 150 # simulate via inverse transform method
 norminvp(runif(d),l = 1:d, u = rep(Inf, d))
}
\references{
Z. I. Botev (2017), \emph{The Normal Law Under Linear Restrictions:
Simulation and Estimation via Minimax Tilting}, Journal of the Royal
Statistical Society, Series B, \bold{79} (1), pp. 1--24.
}
\seealso{
\code{\link{trandn}}
}
\author{
Zdravko I. Botev
}
\keyword{internal}
