

#' @title Tukey \eqn{g}-&-\eqn{h} Distribution
#'
#' @description
#'
#' Density, cumulative density, quantile and simulation of 
#' the 4-parameter Tukey (1977) \eqn{g}-&-\eqn{h} distributions. 
#' The quantile-based transformation (Hoaglin 1985) 
#' and its reverse transformation, 
#' as well as the letter-value based estimates (Hoaglin 1985), 
#' are also provided.
#'
#' @returns
#' Returned values of individual functions are documented separately.
#' 
#' @references
#' Tukey, J.W. (1977): Modern Techniques in Data Analysis. 
#' In: NSF-sponsored Regional Research Conference at Southeastern Massachusetts University, 
#' North Dartmouth, MA. 
#' 
#' Hoaglin, D.C. (1985): Summarizing shape numerically: The \eqn{g}-and-\eqn{h} distributions. 
#' Exploring data tables, trends, and shapes, pp. 461–513. 
#' John Wiley & Sons, Ltd, New York. 
#' \doi{10.1002/9781118150702.ch11}
#'
#' @author Tingting Zhan
#'
#' @keywords internal
'_PACKAGE'

