% Generated by roxygen2 (4.0.1): do not edit by hand
\name{turtle_goto}
\alias{turtle_goto}
\alias{turtle_setangle}
\alias{turtle_setpos}
\title{Set the Turtle's Position and Direction}
\usage{
turtle_goto(x, y)

turtle_setpos(x, y)

turtle_setangle(angle)
}
\arguments{
\item{x,y}{numeric; coordinates specifying new Turtle's location.}

\item{angle}{numeric; rotation angle in degrees.}
}
\description{
\code{turtle_goto} and \code{turtle_setpos} move the Turtle to a
given location without changing its direction.

\code{turtle_setangle}
rotates the Turtle to a given (absolute) angle,
where 0 denotes a north-facing Turtle.
}
\details{
The terrarium must be initialized prior to using
these functions, see \code{\link{turtle_init}}.

If the given location (x, y) lies outside the terrarium,
the behavior of these functions depends
on the \code{mode} argument in \code{\link{turtle_init}}.

\code{turtle_goto} may draw the path between the current Turtle's
position and the new location. Its behavior depends on the current
plot settings,
see \code{\link{turtle_up}}, \code{\link{turtle_down}}. In case of
\code{turtle_setpos}, however, the path drawing is always disabled.
}
\seealso{
Other TurtleGraphics: \code{\link{TurtleGraphics-package}};
  \code{\link{turtle_backward}},
  \code{\link{turtle_forward}}, \code{\link{turtle_move}};
  \code{\link{turtle_col}}, \code{\link{turtle_lty}},
  \code{\link{turtle_lwd}}, \code{\link{turtle_param}};
  \code{\link{turtle_down}}, \code{\link{turtle_up}};
  \code{\link{turtle_do}}; \code{\link{turtle_getangle}},
  \code{\link{turtle_getpos}}; \code{\link{turtle_hide}},
  \code{\link{turtle_show}}; \code{\link{turtle_init}};
  \code{\link{turtle_left}}, \code{\link{turtle_right}},
  \code{\link{turtle_turn}}; \code{\link{turtle_reset}};
  \code{\link{turtle_status}}
}

