% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_lda.R
\name{find_lda}
\alias{find_lda}
\title{Find best LDA model}
\usage{
find_lda(pooled_dfm, search_space = seq(1, 10, 2), method = "Gibbs", ...)
}
\arguments{
\item{pooled_dfm}{object of class dfm (see \link[quanteda]{dfm}) containing (pooled) tweets}

\item{search_space}{Vector with number of topics to compare different models.}

\item{method}{The method to be used for fitting.
Currently method = "VEM" or method = "Gibbs" are supported.}

\item{...}{Additional arguments passed to \link[ldatuning]{FindTopicsNumber}.}
}
\value{
Plot with different metrics compared.
}
\description{
Find the optimal hyperparameter k for your LDA model
}
\examples{
\dontrun{

library(Twitmo)

# load tweets (included in package)
mytweets <- load_tweets(system.file("extdata", "tweets_20191027-141233.json", package = "Twitmo"))

# Pool tweets into longer pseudo-documents
pool <- pool_tweets(data = mytweets)
pooled_dfm <- pool$document_term_matrix

# use the ldatuner to compare different K
find_lda(pooled_dfm, search_space = seq(1, 10, 1),  method = "Gibbs")
}
}
\seealso{
\link[ldatuning]{FindTopicsNumber}
}
