% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_lda.R
\name{lda_hashtags}
\alias{lda_hashtags}
\title{View Documents (hashtags) heavily associated with topics}
\usage{
lda_hashtags(lda_model)
}
\arguments{
\item{lda_model}{Fitted LDA Model. Object of class \link[topicmodels:TopicModel-class]{LDA}).}
}
\value{
Data frame with most likely topic for each hashtag.
}
\description{
Convenience Function to extract the most likely topics for each hashtag.
}
\examples{
\dontrun{

library(Twitmo)

# load tweets (included in package)
mytweets <- load_tweets(system.file("extdata", "tweets_20191027-141233.json", package = "Twitmo"))

# Pool tweets into longer pseudo-documents
pool <- pool_tweets(data = mytweets)
pooled_dfm <- pool$document_term_matrix

# fit your LDA model with 7 topics
model <- fit_lda(pooled_dfm, n_topics = 7, method = "Gibbs")

lda_hashtags(model)
}
}
